<?php

/**
 * Users Class
 */
class Users {
    
     //db instance
    public $db;
    public $mailObject;

    /*
     * Constructor
     */
    function __construct() {

        global $db;
        global $mailObject;
        
        $this -> db = $db;
        $this -> mail = $mailObject;
        
    }
    
    /*
     * Add new user
     * @param array $user_info
     * @return $result
     */
    public function add($user_info = array()) {
        return $this->db->_insert_replace_helper("users", $user_info);
    }
    
    /*
     * Delete user
     * @param int $user_ID
     * @return bool 
     */
    public function delete($user_ID) {
        return $this->db->query("DELETE FROM users WHERE userID = '$user_ID'");
    }
    
    /*
     * Edit user
     * @param array $user_info
     * @param int $user_ID
     * @return bool
     */
     public function edit($user_info, $user_ID = 'current') {
         $user_ID = ($user_ID == 'current') ? $this->ID() : $user_ID;
         
         return $this->db->update("users", $user_info, sprintf("WHERE `userID` = '%d'", $user_ID));
         
     }
     
     /*
      * Login user
      * @param string $username
      * @param string $password
      * @return int $user_ID
      */
     public function login($username, $password) {
         $username = $this->db->escape($username);
         
         $uID = $this->db->get_row("SELECT userID FROM users WHERE email = '$username' AND 
                                    password = '".md5($this->db->escape($password))."'");
         
         if($uID) return $uID->userID;
         
         return false;
                                                 
     }
     
     
     /*
      * Logout user
      */
      public function logout() {
          $_SESSION['userID'] = NULL;
          unset($_SESSION['userID']);
      }
    
     /*
      * Get current user ID
      */
      public function ID() {
          if(isset($_SESSION['userID']) && !empty($_SESSION['userID'])) {
              return intval($_SESSION['userID']);
          }
          
          return false;
      }
      
      
      /*
       * Get current username
       */
       
       public function username() {
           
           $userID = $this->ID();
           $u = $this->db->get_row("SELECT email FROM users WHERE userID = '$userID'");
           
           if($u) return $u->uname;
           
           return false;
           
       }


       /*
        * User details
        */
        public function details() {
           $userID = $this->ID();
           $u = $this->db->get_row("SELECT * FROM users WHERE userID = '$userID'");
           
           if($u) return $u;
           
           return false;
        }
        
        
        /*
         * Reset email sending
         */
       public function reset_email($u = stdObject) {
           
           $domain = $_SERVER['HTTP_HOST'];
           $email_link = sprintf('http://%s/reset.php?h=%d-%s', $domain ,$u->userID, $u->password);
           $email_body = sprintf("<html><head></head><body>You recently requested a password reset on %s, <br/>
                                Please click this <a href='%s'>reset link</a> in order to get a new password.
                                </body></html>", $domain, $email_link);
           try { 
                
               $headers  = 'MIME-Version: 1.0' . "\r\n";
               $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
                   
               mail($u->email, $domain . " Password Reset", $email_body, $headers); 
                
               return true;
           } catch (exception $e) {
               return $e->getMessage();
           }
                                
       }
       
       /*
        * Send new reset password
        */
        public function send_new_email($userID, $string_password) {
            $u_details = $this->db->get_row(sprintf("SELECT email FROM users WHERE userID = %d", $userID));
            $domain = $_SERVER['HTTP_HOST'];
            
            if($u_details) {
                try {
                   
                   $headers  = 'MIME-Version: 1.0' . "\r\n";
                   $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
                   
                   mail($u_details->email, $domain . " New Password", sprintf("Your new password is %s", $string_password), $headers);
                   
                   
                   $this->db->update("users", array("password" => md5($string_password)), " WHERE userID = $userID");
                   
                   return true;
               } catch (exception $e) {
                   return $e->getMessage();
               }    
            }
            
            return false;
            
        }
       
}
